﻿/**
 * Invoice.cs
 * 
 * The MIT License (MIT)
 *
 * @copyright Copyright(C) 2017 4Customers UG
 * @author    Markus Bröker<broeker.markus@googlemail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using static Sales.Payment;

namespace Sales
{
    delegate double InvoiceDelegate();

    class Invoice
    {
        private double value = 0;
        private PaymentType till;

        public Invoice(double value, PaymentType till)
        {
            this.value = value;
            this.till = till;

            InvoiceDelegate invoiceDelegateReference = this.Rabatt;
            invoiceDelegateReference += this.AddTax;
            invoiceDelegateReference += this.Skonto;

            invoiceDelegateReference();
        }

        public double getFinalResult()
        {            
            return value;
        }

        // Rabatt auf den Netto Preis
        private double Rabatt()
        {
            if (value > 1000.0)
            {
                value *= 0.75;
            }
            else if (value > 500.0)
            {
                value *= 0.85;
            }

            return value;
        }

        // Steuern auf den rabattierten Nettopreis
        private double AddTax()
        {
            value *= 1.19;
            return value;
        }

        // Skonto immer zum Schluss
        private double Skonto()
        {
            switch (till)
            {
                case PaymentType.NOW:
                    value *= 0.97;
                    break;
                case PaymentType.WEEK:
                    value *= 0.98;
                    break;
                case PaymentType.MONTH:
                    value *= 0.99;
                    break;
            }

            return value;
        }
    }
}
