﻿/**
 * Invoice.cs
 * 
 * @author       Markus Bröker<broeker.markus@googlemail.com>
 * @copyright    Copyright(C) 2017 4Customers UG
 * 
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using static Sales.Payment;

namespace Sales
{
    delegate double InvoiceDelegate();

    class Invoice
    {
        private double value = 0;
        private PaymentType till;

        public Invoice(double value, PaymentType till)
        {
            this.value = value;
            this.till = till;

            InvoiceDelegate invoiceDelegateReference = this.Rabatt;
            invoiceDelegateReference += this.AddTax;
            invoiceDelegateReference += this.Skonto;

            invoiceDelegateReference();
        }

        public double getFinalResult()
        {            
            return value;
        }

        //Rabatt auf den Netto Preis
        private double Rabatt()
        {
            if (value > 1000.0)
            {
                value *= 0.75;
            }
            else if (value > 500.0)
            {
                value *= 0.85;
            }

            return value;
        }

        // Steuern auf den rabattierten Nettopreis
        private double AddTax()
        {
            value *= 1.19;
            return value;
        }

        // Skonto immer zum Schluss
        private double Skonto()
        {
            switch (till)
            {
                case PaymentType.NOW:
                    value *= 0.97;
                    break;
                case PaymentType.WEEK:
                    value *= 0.98;
                    break;
                case PaymentType.MONTH:
                    value *= 0.99;
                    break;
            }

            return value;
        }
    }
}
