/*
 *  $Id: PacketParser.h 2 2007-12-22 14:15:30Z mbroeker $
 * $URL: http://localhost/svn/cpp/qMonitor/trunk/include/PacketParser.h $
 */

#ifndef PACKET_PARSER
#define PACKET_PARSER

#include <PacketReader.h>
#include <sstream>
#include <iomanip>
#include <tools.h>

extern "C" {
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netinet/ip_icmp.h>
} class PacketParser:public PacketReader {
  public:
    PacketParser (int tm = 500);
      PacketParser (std::string);
     ~PacketParser ();
      std::string read ();
      std::string getPacket ();
    void setPort (unsigned short);
    void setProtocol (int);
      std::string getProtocol (int);

  private:
      std::string str;
    int protocol;
    unsigned short port;

      std::string shost;
      std::string dhost;
    unsigned short sport, dport;
    struct protoent *proto;
};

#endif
