/**
 *  $Id: config.c 51 2008-01-10 00:19:39Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/config.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compat.h>
#include <config.h>
#include "common.h"

enum config_map {
    NICK, PASSWORD, SERVER, PORT, CHANNEL, TOPIC,
};

const
char *CONFIG_OPTIONS[] = {
    "NICK", "PASSWORD", "SERVER", "PORT",
    "CHANNEL", "TOPIC", NULL
};

int config (UC * uc, char *fname)
{
    FILE *f;
    char buffer[DEFAULT_BUF_SIZE];
    char **line;
    char *token;
    char *value;
    enum config_map map = 0;

    if ((f = fopen (fname, "r")) == NULL)
        return -1;

    while (CONFIG_OPTIONS[map] != NULL)
        map++;

    if ((line = calloc ((size_t) (map + 1), sizeof (char *))) == NULL) {
        fclose (f);
        return -1;
    }

    /*
     * We can easily provide default values ...
     */
    uc->nick = uc->pass = uc->server = uc->channel = uc->topic = NULL;
    uc->port = "6667";

    while (!feof (f)) {
        if (fgets (buffer, sizeof (buffer), f) == NULL)
            break;
        token = buffer;

        while (*token == '\t' || *token == ' ') /* Eat trailing tabs and whitespaces */
            token++;

        token = strtok (token, ":");

        if (token != NULL) {
            value = strtok (NULL, "\n");
            map = 0;
            while (CONFIG_OPTIONS[map] != NULL) {
                if (!strcmp (CONFIG_OPTIONS[map], token)) {
                    if (value) {
                        if (line[map] != NULL)
                            free (line[map]);
                        line[map] = compat_strdup (value);
                    }
                }
                map++;
            }
        }
    }

    map = 0;
    while (CONFIG_OPTIONS[map] != NULL) {
        if (line[map] != NULL)
            switch (map) {
            case NICK:
                uc->nick = compat_strdup (line[map]);
                free (line[map]);
                break;
            case PASSWORD:
                uc->pass = compat_strdup (line[map]);
                free (line[map]);
                break;
            case SERVER:
                uc->server = compat_strdup (line[map]);
                free (line[map]);
                break;
            case PORT:
                uc->port = compat_strdup (line[map]);
                free (line[map]);
                break;
            case CHANNEL:
                uc->channel = compat_strdup (line[map]);
                free (line[map]);
                break;
            case TOPIC:
                uc->topic = compat_strdup (line[map]);
                free (line[map]);
                break;
            }
        map++;
    }

    free (line);

    if (fclose (f) != 0)
        return -1;

    if (!(uc->nick && uc->server && uc->channel))
        return -2;

    return 0;
}
