/**
 *  $Id: parse.c 153 2008-04-27 07:26:15Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/parse.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <mcbot.h>
#include <database.h>

#include <locale.h>
#include <libintl.h>

#ifndef DATABASE_FILE
#define DATABASE_FILE "/var/lib/nobody/data/mcbot.dat"
#endif

const
char *COMMAND_LIST[] = {
    "!help      Known Commands: join(1), leave(2), add(3), replace(4), delete(5), list(6), search(7), info(8)\r\n",
    "!join:     Joins a new channel\r\n",
    "!leave:    Parts from the current channel\r\n",
    "!add:      adds an entry\r\n",
    "!replace:  replaces an entry\r\n",
    "!delete:   deletes an entry\r\n",
    "!list:     lists the number of stored values\r\n",
    "!search:   searches an entry up\r\n",
    "!info:     Prints the current Bot-Version\r\n",
    "!ping:     pings an host\r\n",
    "!on:       enables autolearning mode\r\n",
    "!off:      disables autolearning\r\n",
    "!debug:    prints some debug infos\r\n",
    "!vaccuum:  reorganizes the database\r\n",
    "!logout:   Protected logout function\r\n",
};

const
char ITEMS = 14;

const
char *Bot_Commands[] = {
    "!help", "!join", "!leave",
    "!add", "!replace", "!delete",
    "!list", "!search", "!info",
    "!ping", "!on", "!off",
    "!debug", "!vaccuum", "!logout",
    "!who", "!whois", "!time", "!tell",
    "!op", NULL
};

char *parse (MSG * message)
{
    static char msg[513];
    int cmd = -1;
    int i;
    char *token;
    char *parameters;

    time_t t;
    struct tm *timeptr;
    static int counter = 0;

    /*
     * default message
     */
    snprintf (msg, 512, "PRIVMSG %s :%s.\r\n", message->channel, gettext ("Request cannot be performed"));

    /*
     * PRIVATE MESSAGES
     */
    if (!strcmp (message->channel, message->nick))
        message->channel = message->user;

    if (strstr (message->line, message->nick)) {
        if (*message->line != '!') {
            /*
             * DEAD - LOCK - CHECK
             */
            if (strcmp (message->user, message->nick)) {
                snprintf (msg, 512, "PRIVMSG %s :%s, %s?\r\n", message->channel, gettext ("What's up"), message->user);
                if (counter++ > 3)
                    return NULL;
                return msg;
            }
            /*
             * DEAD - LOCK - CHECK ENDS
             */
        }
        return NULL;
    }

    counter = 0;

    /*
     * NO BOT Commands
     */
    if (*message->line != '!') {
        return NULL;
    }

    i = 0;
    token = strtok (message->line, " ");
    while (Bot_Commands[i]) {
        if (!strcmp (token, Bot_Commands[i])) {
            switch (i) {
            case 0:            /* !help */
                if ((token = strtok (NULL, "\r\n")))
                    cmd = atoi (token);
                if ((cmd > 0) && (cmd < ITEMS))
                    snprintf (msg, 512, "PRIVMSG %s :%s\r\n", message->channel, COMMAND_LIST[cmd]);
                else
                    snprintf (msg, 512, "PRIVMSG %s :%s\r\n", message->channel, COMMAND_LIST[0]);
                return msg;

            case 1:            /* !join */
                if ((token = strtok (NULL, "\r\n")))
                    snprintf (msg, 512, "JOIN %s\r\n", token);
                return msg;

            case 2:            /* !leave */
                if (*message->channel != '#')
                    return NULL;
                snprintf (msg, 512, "PART %s :Leaving.\r\n", message->channel);
                return msg;

            case 3:            /* !add */
                if ((token = strtok (NULL, " "))) {
                    if ((parameters = strtok (NULL, "\r\n"))) {
                        snprintf (msg, 512, "PRIVMSG %s :%s, %s\r\n",
                                  message->channel, message->user, db_insert (DATABASE_FILE, token, parameters, 0));
                    } else {
                        snprintf (msg, 512, "PRIVMSG %s :%s, %s!\r\n", message->channel,
                                  gettext ("I need more parameters to add"), message->user);
                    }
                }
                return msg;

            case 4:            /* !replace */
                if ((token = strtok (NULL, " "))) {
                    if ((parameters = strtok (NULL, "\r\n"))) {
                        snprintf (msg, 512, "PRIVMSG %s :%s, %s\r\n",
                                  message->channel, message->user, db_insert (DATABASE_FILE, token, parameters, 1));
                    } else {
                        snprintf (msg, 512, "PRIVMSG %s :%s, %s!\r\n", message->channel,
                                  gettext ("I need more parameters to replace"), message->user);
                    }
                }
                return msg;

            case 5:            /* !delete */
                if ((token = strtok (NULL, "\r\n"))) {
                    snprintf (msg, 512, "PRIVMSG %s :%s, %s\r\n",
                              message->channel, message->user, db_remove (DATABASE_FILE, token));
                } else {
                    snprintf (msg, 512, "PRIVMSG %s :%s, %s!\r\n", message->channel, gettext ("I need a key to delete"),
                              message->user);
                }
                return msg;

            case 6:            /* !count */
                snprintf (msg, 512, "PRIVMSG %s :%s %s\r\n", message->channel, db_elements (DATABASE_FILE),
                          db_lookup (DATABASE_FILE, "mcbot.cgi"));
                return msg;

            case 7:            /* !search */
                if ((token = strtok (NULL, "\r\n"))) {
                    snprintf (msg, 512, "PRIVMSG %s :%s, %s\r\n", message->channel, message->user,
                              db_lookup (DATABASE_FILE, token));
                } else {
                    snprintf (msg, 512,
                              "PRIVMSG %s :%s, %s!\r\n", message->channel, gettext ("I need a key to lookup"),
                              message->user);
                }
                return msg;

            case 8:            /* !info */
                snprintf (msg, 512, "PRIVMSG %s :I am MCBot-%1.2f and my source code can be found on %s\r\n",
                          message->channel, VERSION, "http://largo.homelinux.org/svn/c/mcbot/trunk");
                return msg;

            case 9:            /* !ping */
                if ((token = strtok (NULL, "\r\n")))
                    snprintf (msg, 512, "PRIVMSG %s :PING 0815\r\n", token);
                return msg;

            case 10:           /* !on */
                snprintf (msg, 512, "PRIVMSG %s :%s %s.\r\n", message->user, gettext ("Autolearn enabled for channel"),
                          message->channel);
                return msg;

            case 11:           /* !off */
                snprintf (msg, 512, "PRIVMSG %s :%s %s.\r\n", message->user, gettext ("Autolearn disabled for channel"),
                          message->channel);
                return msg;

            case 12:           /* !debug */
                snprintf (msg, 512, "PRIVMSG %s :USER: %s EMAIL: %s CHANNEL: %s LINE: %s\r\n", message->channel,
                          message->user, message->email, message->channel, message->line);
                return msg;

            case 13:           /* !vaccum */
                snprintf (msg, 512, "PRIVMSG %s :%s\r\n", message->channel, db_vaccuum (DATABASE_FILE));
                return msg;

            case 14:           /* !logout */
                if (strstr (message->user, db_lookup (DATABASE_FILE, "mcbot.user"))) {
                    if (strstr (message->email, db_lookup (DATABASE_FILE, "mcbot.email"))) {
                        snprintf (msg, 512, "PRIVMSG %s :%s!\r\nQUIT\r\n", message->channel,
                                  gettext ("Bye, have a nice day!"));
                    }
                }
                /*
                 * the returned message is either the default one or the generated one
                 */
                return msg;

            case 15:           /* !who */
                if ((token = strtok (NULL, "\r\n")) != NULL) {
                    snprintf (msg, 512, "WHO %s\r\n", token);
                }
                return msg;

            case 16:           /* !whois */
                if ((token = strtok (NULL, "\r\n")) != NULL) {
                    snprintf (msg, 512, "WHOIS %s\r\n", token);
                }
                return msg;

            case 17:           /* time */
                t = time (NULL);
                timeptr = localtime (&t);
                if ((token = malloc (81))) {
                    strftime (token, 80, "%I:%M:%S %p", timeptr);
                    snprintf (msg, 512, "PRIVMSG %s :%s %s, %s!\r\n", message->channel, gettext ("It is"), token,
                              message->user);
                    free (token);
                }
                return msg;

            case 18:           /* tell */
                if ((token = strtok (NULL, " "))) {
                    if ((parameters = strtok (NULL, "\r\n"))) {
                        if (*token == '*')
                            message->channel = ++token;
                        snprintf (msg, 512, "PRIVMSG %s :%s, %s\r\n", message->channel, token,
                                  db_lookup (DATABASE_FILE, parameters));
                    }
                }
                return msg;

            case 19:           /* op */
                if ((token = strtok (NULL, "\r\n")) != NULL) {
                    if (strstr (message->email, db_lookup (DATABASE_FILE, "mcbot.email")))
                        snprintf (msg, 512, "MODE %s +o %s\r\n", message->channel, token);
                }
                return msg;
            }
        }
        i++;
    }

    return NULL;
}
