/**
 *  $Id: database.c 108 2008-04-17 01:01:52Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/database.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdbm.h>

#include <database.h>

char *db_insert (char *file_name, char *name, char *msg, int mode)
{
    GDBM_FILE dbf;
    datum key;
    datum content;
    int ret;

    if ((dbf = gdbm_open (file_name, 512, GDBM_WRCREAT, 0644, 0)) == NULL)
        return "db_insert error";

    key.dptr = name;
    key.dsize = strlen (name) + 1;

    content.dptr = msg;
    content.dsize = strlen (msg) + 1;

    if (mode)
        ret = gdbm_store (dbf, key, content, GDBM_REPLACE);
    else
        ret = gdbm_store (dbf, key, content, GDBM_INSERT);

    gdbm_close (dbf);

    if (!ret)
        return "Key added";

    return "error: key not added";
}

char *db_remove (char *file_name, char *name)
{
    GDBM_FILE dbf;
    datum key;
    int ret;

    if ((dbf = gdbm_open (file_name, 512, GDBM_WRITER, 0, 0)) == NULL)
        return "db_remove error";

    key.dptr = name;
    key.dsize = strlen (name) + 1;

    ret = gdbm_delete (dbf, key);

    gdbm_close (dbf);

    if (!ret)
        return "Key removed";
    return "error: key not removed";
}

char *db_lookup (char *file_name, char *entry)
{
    GDBM_FILE dbf;
    datum content;
    datum key;
    static char msg[513] = { 0 };

    if ((dbf = gdbm_open (file_name, 512, GDBM_READER, 0, 0)) == NULL)
        return "db_lookup error";

    key.dptr = entry;
    key.dsize = strlen (entry) + 1;

    content = gdbm_fetch (dbf, key);
    if (content.dptr != NULL) {
        snprintf (msg, 512, "%s", content.dptr);
        free (content.dptr);
    } else
        snprintf (msg, 512, "I haven't heard anything about %s.", entry);

    gdbm_close (dbf);
    return msg;
}

char *db_elements (char *file_name)
{
    GDBM_FILE dbf;
    datum key, nextkey;
    int count;
    static char msg[81] = { 0 };

    if ((dbf = gdbm_open (file_name, 512, GDBM_READER, 0, 0)) == NULL)
        return "db_lookup error";

    key = gdbm_firstkey (dbf);

    count = 0;
    while (key.dptr != NULL) {
        nextkey = gdbm_nextkey (dbf, key);
        free (key.dptr);
        key = nextkey;
        count++;
    }

    gdbm_close (dbf);
    snprintf (msg, 80, "I am holding %d %s in my database.", count, (count > 0) ? "rows" : "row");
    return msg;
}

char *db_list (char *file_name)
{
    GDBM_FILE dbf;
    datum content;
    datum key, nextkey;
    static char msg[81] = { 0 };
    int count;

    if ((dbf = gdbm_open (file_name, 512, GDBM_READER, 0, 0)) == NULL)
        return "db_list error";

    key = gdbm_firstkey (dbf);

    count = 0;
    while (key.dptr != NULL) {
        content = gdbm_fetch (dbf, key);
        printf ("%11s: %s\n", key.dptr, content.dptr);
        if (content.dptr != NULL)
            free (content.dptr);
        nextkey = gdbm_nextkey (dbf, key);
        free (key.dptr);
        key = nextkey;
        count++;
    }

    gdbm_close (dbf);
    snprintf (msg, 80, "I am holding %d %s in my database.", count, (count > 0) ? "rows" : "row");
    return msg;
}

char *db_vaccuum (char *file_name)
{
    GDBM_FILE dbf;
    static char msg[81] = { 0 };

    if ((dbf = gdbm_open (file_name, 512, GDBM_WRITER, 0, 0)) == NULL)
        return "db_vaccuum error";

    gdbm_reorganize (dbf);

    gdbm_close (dbf);
    snprintf (msg, 80, "I reorganized the database.");
    return msg;
}
