/**
 *  $Id: config.c 171 2008-08-10 18:20:39Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/compat.c $
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compat.h>

char *compat_strdup (const char *s)
{
    char *buf;

    buf = malloc (strlen (s) + 1);
    if (buf != NULL)
        strcpy (buf, s);

    return buf;
}

char *safe_strncpy (char *dest, const char *src, size_t size)
{
    size_t i;

    for (i = 0; i < size - 1; i++) {
        if (src[i] == '\0')
            break;
        dest[i] = src[i];
    }

    dest[i] = '\0';

    return dest;
}
