/**
 *  $Id: main.c 51 2008-01-10 00:19:39Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/main.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <signal.h>
#include <locale.h>
#include <libintl.h>

#include <mcbot.h>
#include <config.h>
#include "common.h"

#ifndef CONFIG_FILE
#define CONFIG_FILE "/var/lib/mcbot/.mcbotrc"
#endif

#ifndef LOCALE_PATH
#define LOCALE_PATH "/var/lib/mcbot/data/locale"
#endif

short active = 1;               /* needed for a safe shutdown */

void sigproc ()
{
    signal (SIGTERM, sigproc);
    active = 0;
}

int main (int argc, char **argv)
{
    UC uc;
    MSG message;
    char buf[DEFAULT_BUF_SIZE];
    char *msg;
    char *command;
    int len;

    if (bindtextdomain ("mcbot", LOCALE_PATH) != NULL) {
        (void)textdomain ("mcbot");
        (void)setlocale (LC_MESSAGES, "");
    }

    printf ("mcbot-%1.2f Build %s\n", BOT_VERSION, BOT_BUILD);

    if ((len = config (&uc, CONFIG_FILE)) != 0) {
        switch (len) {
        case -1:
            printf ("You need to create a config file %s\n", CONFIG_FILE);
            break;
        case -2:
            printf ("You need at least entries for user, server and channel in your config file %s\n", CONFIG_FILE);
            break;
        }
        return len;
    }

    if (uc.nick)
        message.nick = uc.nick;
    else
        return -1;

    if (!(message.stream = irc_connect (uc.server, uc.port)))
        return EXIT_FAILURE;

    if ((len = irc_login (message.stream, uc.server, uc.nick, uc.pass)) != 0) {
        switch (len) {
        case IRC_GENERAL_ERROR:
            printf ("GENERAL ERROR\n");
            break;
        case IRC_LOGIN_ERROR:
            printf ("LOGIN ERROR\n");
            break;
        default:
            printf ("Unknown Error %d\n", len);
        }
        return len;
    }

    signal (SIGTERM, sigproc);

    if (uc.channel) {
        fprintf (message.stream, "JOIN :%s\r\n", uc.channel);
        strncpy (message.current_channel, uc.channel, 40);
        if (uc.topic)
            fprintf (message.stream, "TOPIC %s :%s\r\n", uc.channel, uc.topic);
    }

    while (!feof (message.stream)) {
        fgets (buf, sizeof (buf), message.stream);

        if (!active)            /* the bot was killed with SIGTERM */
            break;

        if ((command = irc_parsemessage (buf, &message))) {
            if (!strcmp (command, "ERROR") || !strcmp (command, "ENOMEM"))
                break;
            printf ("%10s %s %s\n", command, message.channel, message.line);
        } else {
            if ((msg = parse (&message)) != NULL) {
                fprintf (message.stream, "%s\r\n", msg);
                fflush (message.stream);
                printf ("%10s %s", "WRITE", msg);
            }
        }
        fflush (stdout);
    }
    printf ("\n\nClosing Connection\n\n");
    fclose (message.stream);

    /*
     * cleanup
     */
    if (uc.nick)
        free (uc.nick);
    if (uc.pass)
        free (uc.pass);
    if (uc.server)
        free (uc.server);
    if (uc.channel)
        free (uc.channel);
    if (uc.topic)
        free (uc.topic);

    return EXIT_SUCCESS;
}
