/**
 *  $Id: dbtool.c 51 2008-01-10 00:19:39Z mbroeker $
 * $URL: http://localhost/svn/c/mcbot/trunk/src/dbtool.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#include <database.h>

#ifndef FILE_NAME
#define FILE_NAME "/var/lib/mcbot/data/mcbot.dat"
#endif

void help (char *prgname)
{
    printf ("Usage: %s {-a|-r} -k <key> -v <value>] [-f <file>]\n", prgname);
    printf ("       %s {-s|-d} <key> [-f <file>]\n", prgname);
    printf ("       %s {-l|-V} [-f <file>]\n", prgname);
    printf ("       %s [-h|-?]\n\n", prgname);
    printf ("Administration tool for adding/replacing, deleting, ... of DataBase Entries.\n\n");
    printf ("Options:\n");
    printf ("  -a\t\tadds a new key <key> with value <value> to the db\n");
    printf ("  -r\t\treplaces a key <key> with value <value> in the db\n");
    printf ("  -d\t\tdeletes a <key> from the db\n");
    printf ("  -f\t\tsets the db file\n");
    printf ("  -l\t\tlists the db entries\n");
    printf ("  -s\t\tsearches the db entry <key>\n");
    printf ("  -V\t\treorganizes the db\n");
    printf ("  -h\t\tprints this help\n");
    printf ("  -?\t\tprints this help\n\n");
    printf ("Report bugs to mbroeker@4customers.de\n");
    exit (0);
}

#define     ADD 1
#define REPLACE 2
#define  DELETE 3
#define  SEARCH 4
#define    LIST 5
#define VACCUUM 6

int main (int argc, char **argv)
{
    int i;
    int mode = 0;
    char *key = NULL;
    char *value = NULL;
    char *file_name = NULL;

    while ((i = getopt (argc, argv, "arlVh?d:f:k:s:v:")) > 0) {
        switch (i) {
        case '?':
        case 'h':
            help (argv[0]);
            break;
        case 'a':
            mode = ADD;
            break;
        case 'r':
            mode = REPLACE;
            break;
        case 'd':
            mode = DELETE;
            key = optarg;
            break;
        case 'f':
            file_name = optarg;
            break;
        case 'k':
            key = optarg;
            break;
        case 's':
            key = optarg;
            mode = SEARCH;
            break;
        case 'v':
            value = optarg;
            break;
        case 'l':
            mode = LIST;
            break;
        case 'V':
            mode = VACCUUM;
            break;
        default:
            printf ("Unknown Option %c\n", i);
        }
    }

    for (i = optind; i < argc; i++) {
        printf ("Unknown Parameter: %s\n", argv[i]);
    }

    if (!file_name)
        file_name = FILE_NAME;

    switch (mode) {
    case ADD:
        if ((key != NULL) && (value != NULL))
            printf ("%s\n", db_insert (file_name, key, value, 0));
        else
            help (argv[0]);
        break;
    case REPLACE:
        if ((key != NULL) && (value != NULL))
            printf ("%s\n", db_insert (file_name, key, value, 1));
        else
            help (argv[0]);
        break;
    case DELETE:
        if (key != NULL)
            printf ("%s\n", db_remove (file_name, key));
        else
            help (argv[0]);
        break;
    case SEARCH:
        if (key != NULL)
            printf ("%s\n", db_lookup (file_name, key));
        else
            help (argv[0]);
        break;
    case LIST:
        printf ("%s\n", db_list (file_name));
        break;
    case VACCUUM:
        printf ("%s\n", db_vaccuum (file_name));
        break;
    default:
        printf ("Nothing to do: Try %s -h\n", argv[0]);
    }

    return EXIT_SUCCESS;
}
