/**
 * bluetooth.c
 * Copyright (C) 2010 Markus Bröker
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>

int main (int argc, char **argv)
{
    struct sockaddr_rc addr = { 0 };
    int s, status;
    // Hard-coded for simplicity
    char dest[18] = "58:17:0C:FF:36:D7";    // E10i

    // allocate a socket
    s = socket (AF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM);

    // set the connection parameters (who to connect to)
    addr.rc_family = AF_BLUETOOTH;
    addr.rc_channel = (uint8_t) 1;
    str2ba (dest, &addr.rc_bdaddr);

    // connect to server
    status = connect (s, (struct sockaddr *)&addr, sizeof (addr));

    // send a message
    if (status == 0) {
        status = write (s, "hello!", 6);
    }

    if (status < 0)
        perror ("uh oh");

    close (s);

    return EXIT_SUCCESS;
}
