/**
 * ddos/client.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in.h>

#define MAXLEN 80

int client_write (int client_socket, char *s)
{
    return write (client_socket, s, strlen (s));
}

int main (int argc, char **argv)
{
    char message[MAXLEN + 1];
    int client_socket;
    int status;

    struct addrinfo hints, *result, *rp;

    memset (&hints, 0, sizeof (struct addrinfo));
    hints.ai_family = AF_UNSPEC;
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_flags = 0;
    hints.ai_protocol = IPPROTO_TCP;

    if (getaddrinfo ("localhost", "4000", &hints, &result) != 0) {
        perror ("getaddrinfo");
        return -1;
    }

    client_socket = -1;
    for (rp = result; rp != NULL; rp = rp->ai_next) {
        if ((client_socket = socket (rp->ai_family, rp->ai_socktype, rp->ai_protocol)) == -1)
            continue;

        if (connect (client_socket, rp->ai_addr, rp->ai_addrlen) != -1) {
            break;
        }
        close (client_socket);
        client_socket = -1;
    }

    if (result != NULL)
        freeaddrinfo (result);

    status = client_write (client_socket, "Hello\r\n");
    while (client_socket > 0) {
        status = read (client_socket, message, MAXLEN);
        if (status > 0) {
            message[status] = '\0';
            printf ("SERVER RESPONS: %s", message);
        } else {
            perror ("READ");
            close (client_socket);
            return 1;
        }
    }

    return close (client_socket);
}
