/*
 * cpuinfo.c
 */

#include <cpuid.h>

char *get_cpu_brand (int function)
{
    ULONG brand[4];

    static char s[48];

  __asm__ ("cpuid":"=a" (brand[0]), "=b" (brand[1]), "=c" (brand[2]), "=d" (brand[3])
  :         "a" (function)
        );

    memcpy (s, brand, sizeof (brand));
    return s;
}

char *get_cpu_vendor ()
{
    ULONG vendor[3];
    static char s[15];

    *s = 0;

  __asm__ ("cpuid":"=b" (vendor[0]), "=d" (vendor[1]), "=c" (vendor[2])
  :         "a" (0)
        );

    memcpy (s, vendor, sizeof (vendor));
    return s;
}

ULONG get_cpu_function (ULONG function, ULONG * ax, ULONG * bx, ULONG * cx, ULONG * dx)
{
  __asm__ ("cpuid":"=a" (*ax), "=b" (*bx), "=c" (*cx), "=d" (*dx)
  :         "a" (function)
        );

    return (ULONG) (*ax);
}
