/**
 * test/demos/lsflib/include/lsf.h
 * Copyright (C) 2008 Markus Broeker
 */

#ifndef __LSF_H__
#define __LSF_H__

#ifndef LINE_LENGTH
#define LINE_LENGTH 100
#endif

#include <stdio.h>
#ifndef __LIST__H
#include <lsf/list.h>
#endif

/* tokenizer splits a file into tokens */
Node *tokenizer (FILE *, const char *);

/* tokenchar splits a file into chars */
int tokenchar (FILE *);

/* get_line returns a multiline string str="...\n..." */
char *get_line (const char *, const char *, size_t);

/* isDir returns true, if a fd points to a dir */
int isDir (char *);

/* isDir returns true, if a fd points to a file */
int isFile (char *);

/* getdir prints a dir hierarchy */
void getdir (char *, int);

/* returns a pointer int*  */
unsigned char *md5sum (char *);

void md5recursive (char *, int);

#endif
