/**
 * test/demos/lsflib/src/tokenchar.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>

#define MAXCHARS 80

int tokenchar (FILE * f)
{
    char line[MAXCHARS];
    int i;
    int lines;
    int chars;

    lines = chars = 0;
    *line = 0;

    while ((fgets (line, MAXCHARS, f)) != NULL) {
        for (i = 0; i < strlen (line); i++) {
            switch (line[i]) {
            case '.':
                printf ("%c\n", line[i]);
                lines++;
                break;

            case '?':
                printf ("%c\n", line[i]);
                lines++;
                break;

            case '\n':
                lines++;
                break;

            case '\t':
                break;

            default:
                printf ("UNKNOWN CHAR: %c\n", line[i]);
                chars++;
                break;
            }
        }
        *line = 0;
    }

    rewind (f);
    return chars;
}
