/**
 * jdisa
 *
 * ByteCode Disassembler
 * See http://java.sun.com/docs/books/jvms/second_edition/html/VMSpecTOC.doc.html
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define BUF_SIZE 1023

typedef unsigned char uchar_t;

typedef uchar_t u1[1];
typedef uchar_t u2[2];
typedef uchar_t u4[4];
typedef uchar_t u8[8];

struct Header {
    u4 magic;
    u2 minor_version;
    u2 major_version;
    u2 constant_pool_count;
};

typedef struct Header Header;

int main (int argc, char **argv)
{
    FILE *f;
    uchar_t buffer[BUF_SIZE];
    int i;
    size_t num;
    int OPCODE;
    Header *cf;

    if (argc != 2) {
        fprintf (stderr, "Usage: %s <FILE>\n", argv[0]);
        return EXIT_FAILURE;
    }

    if ((f = fopen (argv[1], "r")) == NULL) {
        perror ("FOPEN");
        return EXIT_FAILURE;
    }

    if ((cf = malloc (sizeof (Header))) == NULL)
        return EXIT_FAILURE;
    if ((num = fread (cf, 1, sizeof (Header), f)) < 1)
        return EXIT_FAILURE;

    printf ("  MAGIC: %2X%2X%2X%2X\n", cf->magic[0], cf->magic[1], cf->magic[2], cf->magic[3]);
    printf ("VERSION: %02d.%02d\n", cf->major_version[1], cf->major_version[0]);
    printf ("POOLCTN: %2d:%2d\n", cf->constant_pool_count[1], cf->constant_pool_count[0]);

    if (cf != NULL)
        free (cf);

    OPCODE = 1;
    while (!feof (f)) {
        num = fread (buffer, 1, sizeof (buffer), f);
        for (i = 0; i < num; i++) {
            if (OPCODE) {
                switch (buffer[i]) {
                case 50:
                    printf ("aaload ");
                    break;
                case 83:
                    printf ("aastore ");
                    break;
                case 1:
                    printf ("aconst_null ");
                    break;
                case 25:
                    printf ("aload ");
                    break;
                case 42:
                    printf ("aload_0 ");
                    break;
                case 43:
                    printf ("aload_1 ");
                    break;
                case 44:
                    printf ("aload_2 ");
                    break;
                case 45:
                    printf ("aload_3 ");
                    break;
                case 189:
                    printf ("anewarray ");
                    break;
                case 176:
                    printf ("areturn ");
                    break;
                case 190:
                    printf ("arraylength ");
                    break;
                case 58:
                    printf ("astore ");
                    break;
                case 75:
                    printf ("astore_0 ");
                    break;
                case 76:
                    printf ("astore_1 ");
                    break;
                case 77:
                    printf ("astore_2 ");
                    break;
                case 78:
                    printf ("astore_3 ");
                    break;
                case 191:
                    printf ("athrow ");
                    break;
                case 51:
                    printf ("baload ");
                    break;
                case 84:
                    printf ("bastore ");
                    break;
                case 16:
                    printf ("bipush ");
                    break;
                case 52:
                    printf ("caload ");
                    break;
                case 85:
                    printf ("castore ");
                    break;
                case 192:
                    printf ("checkcast ");
                    break;
                case 144:
                    printf ("d2f ");
                    break;
                case 142:
                    printf ("d2i ");
                    break;
                case 143:
                    printf ("d2l ");
                    break;
                case 99:
                    printf ("dadd ");
                    break;
                case 49:
                    printf ("daload ");
                    break;
                case 82:
                    printf ("dastore ");
                    break;
                case 152:
                    printf ("dcmp ");
                    break;
                case 14:
                    printf ("dconst_0 ");
                    break;
                case 15:
                    printf ("dconst_1 ");
                    break;
                case 111:
                    printf ("ddiv ");
                    break;
                case 24:
                    printf ("dload ");
                    break;
                case 38:
                    printf ("dload_0 ");
                    break;
                case 39:
                    printf ("dload_1 ");
                    break;
                case 40:
                    printf ("dload_2 ");
                    break;
                case 41:
                    printf ("dload_3 ");
                    break;
                case 107:
                    printf ("dmul ");
                    break;
                case 119:
                    printf ("dneg ");
                    break;
                case 115:
                    printf ("drem ");
                    break;
                case 175:
                    printf ("dreturn ");
                    break;
                case 57:
                    printf ("dstore ");
                    break;
                case 71:
                    printf ("dstore_0 ");
                    break;
                case 72:
                    printf ("dstore_1 ");
                    break;
                case 73:
                    printf ("dstore_2 ");
                    break;
                case 74:
                    printf ("dstore_3 ");
                    break;
                case 103:
                    printf ("dsub ");
                    break;
                case 89:
                    printf ("dup ");
                    break;
                case 90:
                    printf ("dup_x1 ");
                    break;
                case 91:
                    printf ("dup_x2 ");
                    break;
                case 92:
                    printf ("dup2 ");
                    break;
                case 93:
                    printf ("dup2_x1 ");
                    break;
                case 94:
                    printf ("dup2_x2 ");
                    break;
                case 141:
                    printf ("f2d ");
                    break;
                case 139:
                    printf ("f2i ");
                    break;
                case 140:
                    printf ("f2l ");
                    break;
                case 98:
                    printf ("fadd ");
                    break;
                case 48:
                    printf ("faload ");
                    break;
                case 81:
                    printf ("fastore ");
                    break;
                case 150:
                    printf ("fcmpg ");
                    break;
                case 149:
                    printf ("fcmpl ");
                    break;
                case 11:
                    printf ("fconst_0 ");
                    break;
                case 12:
                    printf ("fconst_1 ");
                    break;
                case 13:
                    printf ("fconst_2 ");
                    break;
                case 110:
                    printf ("fdiv ");
                    break;
                case 23:
                    printf ("fload ");
                    break;
                case 34:
                    printf ("fload_0 ");
                    break;
                case 35:
                    printf ("fload_1 ");
                    break;
                case 36:
                    printf ("fload_2 ");
                    break;
                case 37:
                    printf ("fload_3 ");
                    break;
                case 106:
                    printf ("fmul ");
                    break;
                case 118:
                    printf ("fneg ");
                    break;
                case 114:
                    printf ("frem ");
                    break;
                case 174:
                    printf ("freturn ");
                    break;
                case 56:
                    printf ("fstore ");
                    break;
                case 67:
                    printf ("fstore_0 ");
                    break;
                case 68:
                    printf ("fstore_1 ");
                    break;
                case 69:
                    printf ("fstore_2 ");
                    break;
                case 70:
                    printf ("fstore_3 ");
                    break;
                case 102:
                    printf ("fsub ");
                    break;
                case 180:
                    printf ("getfield ");
                    break;
                case 178:
                    printf ("getstatic ");
                    break;
                case 167:
                    printf ("goto ");
                    break;
                case 200:
                    printf ("goto_w ");
                    break;
                case 145:
                    printf ("i2b ");
                    break;
                case 146:
                    printf ("i2c ");
                    break;
                case 135:
                    printf ("i2d ");
                    break;
                case 134:
                    printf ("i2f ");
                    break;
                case 133:
                    printf ("i2l ");
                    break;
                case 147:
                    printf ("i2s ");
                    break;
                case 96:
                    printf ("iadd ");
                    break;
                case 46:
                    printf ("iaload ");
                    break;
                case 126:
                    printf ("iand ");
                    break;
                case 79:
                    printf ("iastore ");
                    break;
                case 2:
                    printf ("iconst_m1 ");
                    break;
                case 3:
                    printf ("iconst_0 ");
                    break;
                case 4:
                    printf ("iconst_1 ");
                    break;
                case 5:
                    printf ("iconst_2 ");
                    break;
                case 6:
                    printf ("iconst_3 ");
                    break;
                case 7:
                    printf ("iconst_4 ");
                    break;
                case 8:
                    printf ("iconst_5 ");
                    break;
                case 108:
                    printf ("idiv ");
                    break;
                case 165:
                    printf ("if_acmpeq ");
                    break;
                case 166:
                    printf ("if_acmpne ");
                    break;
                case 159:
                    printf ("if_icmpeq ");
                    break;
                case 160:
                    printf ("if_icmpne ");
                    break;
                case 161:
                    printf ("if_icmplt ");
                    break;
                case 162:
                    printf ("if_icmpge ");
                    break;
                case 163:
                    printf ("if_icmpgt ");
                    break;
                case 164:
                    printf ("if_icmple ");
                    break;
                case 153:
                    printf ("ifeq ");
                    break;
                case 154:
                    printf ("ifne ");
                    break;
                case 155:
                    printf ("iflt ");
                    break;
                case 156:
                    printf ("ifge ");
                    break;
                case 157:
                    printf ("ifgt ");
                    break;
                case 158:
                    printf ("ifle ");
                    break;
                case 199:
                    printf ("ifnonnull ");
                    break;
                case 198:
                    printf ("ifnull ");
                    break;
                case 132:
                    printf ("iinc %d %d\n", buffer[i + 1], buffer[i + 2]);
                    i += 2;
                    continue;
                    break;
                case 21:
                    printf ("iload ");
                    break;
                case 26:
                    printf ("iload_0 ");
                    break;
                case 27:
                    printf ("iload_1 ");
                    break;
                case 28:
                    printf ("iload_2 ");
                    break;
                case 29:
                    printf ("iload_3 ");
                    break;
                case 104:
                    printf ("imul ");
                    break;
                case 116:
                    printf ("ineg ");
                    break;
                case 193:
                    printf ("instanceof ");
                    break;
                case 185:
                    printf ("invokeinterface ");
                    break;
                case 183:
                    printf ("invokespecial ");
                    break;
                case 184:
                    printf ("invokestatic ");
                    break;
                case 182:
                    printf ("invokevirtual ");
                    break;
                case 128:
                    printf ("ior ");
                    break;
                case 112:
                    printf ("irem ");
                    break;
                case 172:
                    printf ("ireturn ");
                    break;
                case 120:
                    printf ("ishl ");
                    break;
                case 122:
                    printf ("ishr ");
                    break;
                case 54:
                    printf ("istore ");
                    break;
                case 59:
                    printf ("istore_0 ");
                    break;
                case 60:
                    printf ("istore_1 ");
                    break;
                case 61:
                    printf ("istore_2 ");
                    break;
                case 62:
                    printf ("istore_3 ");
                    break;
                case 100:
                    printf ("isub ");
                    break;
                case 124:
                    printf ("iushr ");
                    break;
                case 130:
                    printf ("ixor ");
                    break;
                case 168:
                    printf ("jsr ");
                    break;
                case 201:
                    printf ("jsr_w ");
                    break;
                case 138:
                    printf ("l2d ");
                    break;
                case 137:
                    printf ("l2f ");
                    break;
                case 136:
                    printf ("l2i ");
                    break;
                case 97:
                    printf ("ladd ");
                    break;
                case 47:
                    printf ("laload ");
                    break;
                case 127:
                    printf ("land ");
                    break;
                case 80:
                    printf ("lastore ");
                    break;
                case 148:
                    printf ("lcmd ");
                    break;
                case 9:
                    printf ("lconst_0 ");
                    break;
                case 10:
                    printf ("lconst_1 ");
                    break;
                case 18:
                    printf ("ldc ");
                    break;
                case 19:
                    printf ("ldc_w ");
                    break;
                case 20:
                    printf ("ldc2_w ");
                    break;
                case 109:
                    printf ("ldiv ");
                    break;
                case 22:
                    printf ("lload ");
                    break;
                case 30:
                    printf ("lload_0 ");
                    break;
                case 31:
                    printf ("lload_1 ");
                    break;
                case 32:
                    printf ("lload_2 ");
                    break;
                case 33:
                    printf ("lload_3 ");
                    break;
                case 105:
                    printf ("lmul ");
                    break;
                case 117:
                    printf ("lneg ");
                    break;
                case 171:
                    printf ("lookupswitch ");
                    break;
                case 129:
                    printf ("lor ");
                    break;
                case 113:
                    printf ("lrem ");
                    break;
                case 173:
                    printf ("lreturn ");
                    break;
                case 121:
                    printf ("lshl ");
                    break;
                case 123:
                    printf ("lshr ");
                    break;
                case 55:
                    printf ("lstore ");
                    break;
                case 63:
                    printf ("lstore_0 ");
                    break;
                case 64:
                    printf ("lstore_1 ");
                    break;
                case 65:
                    printf ("lstore_2 ");
                    break;
                case 66:
                    printf ("lstore_3 ");
                    break;
                case 101:
                    printf ("lsub ");
                    break;
                case 125:
                    printf ("lushr ");
                    break;
                case 131:
                    printf ("lxor ");
                    break;
                case 194:
                    printf ("monitorenter ");
                    break;
                case 195:
                    printf ("monitorexit ");
                    break;
                case 197:
                    printf ("multianewarray ");
                    break;
                case 187:
                    printf ("new ");
                    break;
                case 188:
                    printf ("newarray ");
                    break;
                case 0:
                    printf ("nop ");
                    break;
                case 87:
                    printf ("pop ");
                    break;
                case 88:
                    printf ("pop2 ");
                    break;
                case 181:
                    printf ("putfield ");
                    break;
                case 179:
                    printf ("putstatic ");
                    break;
                case 169:
                    printf ("ret ");
                    break;
                case 177:
                    printf ("return ");
                    break;
                case 53:
                    printf ("saload ");
                    break;
                case 86:
                    printf ("sastore ");
                    break;
                case 17:
                    printf ("sipush ");
                    break;
                case 95:
                    printf ("swap ");
                    break;
                case 170:
                    printf ("tableswitch ");
                    break;
                case 196:
                    printf ("wide ");
                    break;
                case 202:      /* reserved item */
                    printf ("breakpoint ");
                    break;
                case 254:      /* reserved item */
                    printf ("impdep1 ");
                    break;
                case 255:      /* reserved item */
                    printf ("impdep2 ");
                    break;
                default:
                    printf ("OPCODE %02X(%d) ", buffer[i], buffer[i]);
                }
                OPCODE = 0;
            } else
                switch (buffer[i]) {
                case '\0':
                case '>':
                case '<':
                    printf ("\n");
                    OPCODE = 1;
                    break;
                default:
                    if (isprint (buffer[i]))
                        printf ("%c", buffer[i]);
                    else
                        printf ("%02X ", buffer[i]);
                }
        }
    }

    printf ("\n");

    if (f != NULL)
        fclose (f);

    return EXIT_SUCCESS;
}
