/**
 * lsflib/src/md5recursive.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <lsf/lsf.h>

void md5recursive (char *root, int recursive)
{
    struct dirent *entry;
    DIR *directory;
    char *list;
    unsigned char *value;
    int i;

    if (!isDir (root))
        return;

    if ((directory = opendir (root)) == NULL) {
        perror (root);
        return;
    }

    while ((entry = readdir (directory))) {
        if ((!strcmp (entry->d_name, ".")) || (!strcmp (entry->d_name, "..")))
            continue;

        list = malloc (strlen (root) + 1 + strlen (entry->d_name) + 1);
        sprintf (list, "%s/%s", root, entry->d_name);

        if (isDir (list)) {
            fprintf (stderr, "Directory: %s\n", list);

            if (recursive) {
                md5recursive (list, recursive);
            }
            free (list);
            continue;
        }

        if ((value = md5sum (list)) == NULL) {
            continue;
        }

        for (i = 0; i < 16; i++)
            printf ("%02x", value[i]);
        printf ("  %s\n", list);
        free (list);
        free (value);
    }

    closedir (directory);
}
