;;
;; hello.asm
;; Basics in Assembler
;;
global start
global _entryPoint

%define  SYSCALL_EXIT 0x1
%define SYSCALL_WRITE 0x4
%define SYS_INTERRUPT 0x80

section .data
  msg db "ASM Tutorial for 32 Bit Intel!", 10, 0
  len equ $-msg

  buffer: times 100 db '.'
  quotient: dd 10

section .text

start:
  call _entryPoint
  mov eax, 1000
  mov ebx, -1024
  call calculate

  mov eax, 1000
  mov ebx, 1024
  call calculate

  call asm_exit
  ret

asm_exit:
  push DWORD 0
  mov eax, SYSCALL_EXIT
  int SYS_INTERRUPT
  ret

asm_write:
  mov eax, SYSCALL_WRITE
  int SYS_INTERRUPT
  ret

;;
;;  CL: NEGATIVE BIT - BOOLEAN
;; EAX: NUMBER TO CONVERT
;; EBX: counter
;;
integerToString:
  xor cl, cl

  mov ebx, 0
  lea si, [buffer]
  mov di, si

  cmp eax, 0
  jg loop

  ;; SET NEGATIVE
  mov cl, 1

  ;; reverse internal negative representation
  not eax
  inc eax

  loop:
    xor edx, edx
    idiv DWORD [quotient]
    add edx, 30h
    mov [si], edx
    inc si
    inc ebx

    cmp eax, 0
    jne loop

  ;; Save current string position
  push si

  ;; ADD +/- SIGN
  cmp cl, 0
  jz positive
  jg negative

  positive:
    mov BYTE [si], '+'
    jmp reverse

  negative:
    mov BYTE [si], '-'
    jmp reverse

  ;; Reverse the number in human readable format
  reverse:
	;; swap first with last and so on
    mov al, BYTE [si]
    mov ah, BYTE [di]
    mov BYTE [si], ah
    mov BYTE [di], al

    dec si
    inc di

    ;; 1 2 3 4 5 6
    ;; 6         1
    ;;   5     2
    ;;     4 3
    ;;
    cmp si, di
    jg reverse

  ;; Restore current String position
  pop di

  ;; add newline and string terminator
  newline:
    inc di
    mov BYTE [di], 10
    inc di
    mov BYTE [di], 0
    inc di

    ;; add the two chars to the counter
    add ebx, 2

  ret

calculate:
  imul ebx
  call integerToString

  push DWORD ebx
  push DWORD buffer
  push DWORD 1

  call asm_write

  add esp, 12
  ret

_entryPoint:
  push DWORD len      ;; Text Len
  push DWORD msg      ;; Pointer to String
  push DWORD 1        ;; stdout

  call asm_write      ;;
  
  add esp, 12         ;; cleanup stack
  ret
