#include <stdio.h>
#include <stdlib.h>

#include <lsf.h>

int main (int argc, char **argv)
{
    unsigned char *value = NULL;
    int i;

    if (argc != 2) {
        printf ("Usage: %s [ <file> | <directory> ]\n\n", argv[0]);
        printf ("Output is in md5sum compatible format\n");
        return EXIT_SUCCESS;
    }

    if (isDir (argv[1]))
        md5recursive (argv[1], 1);
    else {
        value = md5sum (argv[1]);

        if (!value) {
            printf ("There was an error\n");
            free (value);
            return EXIT_FAILURE;
        }
        for (i = 0; i < 16; i++)
            printf ("%02x", value[i]);
        printf ("  %s\n", argv[1]);
        if (value)
            free (value);
    }

    return 0;
}
