/* 
 *  $Id$
 * $URL$
 */

%{
   #include <stdio.h>
   #include <ctype.h>

   int regs[26]; 
   int base;
	
   int yyerror();
   int yylex();
%}

%start list
%token DIGIT LETTER
%left MINUS PLUS MUL DIV
%left UMINUS
%%

list : /* empty */ 
	| list stat '\n' 
	| list error '\n' { yyerrok; };

stat : 
	expr { (void) printf( "RESULT: %d\n", $1 ); } 
	| LETTER '=' expr { regs[$1] = $3; }
	;

   expr      :  '(' expr ')'
             {
                   $$ = $2;
             }
             |  expr PLUS expr
             {
                   $$ = $1 + $3;
             }
             |  expr MINUS expr
             {
                   $$ = $1 - $3;
             }
             |  expr MUL expr
             { 
                   $$ = $1 * $3;
             }
             |  expr DIV expr
             {
                   $$ = $1 / $3;
             }
             |  MINUS expr  %prec UMINUS
             {
                   $$ = -$2;
             }
             |  LETTER
             {
                   $$ = regs[$1];
             }
             |  number
             ;

   number    :   DIGIT
             {
                    $$ = $1; base = ($1==0) ? 8 : 10;
             }
             |   number DIGIT
             {
                    $$ = base * $1 + $2;
             }
             ;
   
%%

int yyerror() 
{
	printf("ERROR\n");
	return 0;
}

int yywrap() 
{
	return 1;
}
