/**
 * test/demos/pmc/pmc.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <iostream>
#include <cmath>
#include <pmc.h>

using namespace pmc;

Vector::Vector (int xx, int yy, int zz)
{
    name = "Vector";
    x = xx;
    y = yy;
    z = zz;
    mode = RAD;
}

Vector::~Vector ()
{
}

int Vector::X ()
{
    return x;
}

int Vector::Y ()
{
    return y;
}

int Vector::Z ()
{
    return z;
}

Vector Vector::operator+ (Vector a)
{
    return Vector (x + a.X (), y + a.Y (), z + a.Z ());
}

Vector Vector::operator- (Vector a)
{
    return Vector (x - a.X (), y - a.Y (), z - a.Z ());
}

int Vector::operator* (Vector a)
{
    return (x * a.X () + y * a.Y () + z * a.Z ());
}

double Vector::abs ()
{
    return (std::sqrt (x * x + y * y + z * z));
}

void Vector::vector ()
{
    std::cout << "(" << x << ", " << y << ", " << z << ")";
}

double Vector::angle (Vector p)
{
    if (mode == DEG)
        return ((180.0 / M_PI) * std::acos ((p ** this) / (abs () * p.abs ())));

    return (std::acos ((p ** this) / (abs () * p.abs ())));
}

void Vector::setMode (Mode m)
{
    mode = m;
}
