/**
 * test/demos/parser/c_compiler/main.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <prototypes.h>

extern FILE *yyin;

void usage (char *cmd)
{
    printf ("Usage: %s <options> <source files>\n", cmd);
}

int main (int argc, char **argv)
{
    FILE *fp;

    if (argc < 2) {
        usage (argv[0]);
        return EXIT_FAILURE;
    }

    if ((fp = fopen (argv[1], "r")) == NULL) {
        perror ("FOPEN");
        return EXIT_FAILURE;
    }

    yyin = fp;
    yyparse ();

    fclose (fp);

    return EXIT_SUCCESS;
}
