/*
 * cpuinfo
 */

#include <stdio.h>
#include <stdlib.h>
#include <cpuid.h>

int main (int argc, char **argv)
{
    signed long i;
    ULONG ax = 0, bx = 0, cx = 0, dx = 0;

    printf ("Vendor     : %s\n", get_cpu_vendor ());
    printf ("Type       : %ld\n", (get_cpu_function (1, &ax, &bx, &cx, &dx) >> 12) & 0x1);
    printf ("Family     : %ld\n", (get_cpu_function (1, &ax, &bx, &cx, &dx) >> 8) & 0xF);
    printf ("Model      : %ld\n", (get_cpu_function (1, &ax, &bx, &cx, &dx) >> 4) & 0xF);
    printf ("Step       : %ld\n", (get_cpu_function (1, &ax, &bx, &cx, &dx) & 0xF));

    if (strcmp (get_cpu_vendor (), "AuthenticAMD")) {
        printf ("Cannot handle NON-AMD-CPUs\n");
        return EXIT_SUCCESS;
    }

    printf ("Extensions : %ld\n", (get_cpu_function (0x80000000, &ax, &bx, &cx, &dx)) & 0xFF);
    printf ("Generation : %ld\n", (get_cpu_function (0x80000001, &ax, &bx, &cx, &dx) >> 8) & 0xF);
    printf ("Model      : %ld\n", (get_cpu_function (0x80000001, &ax, &bx, &cx, &dx) >> 4) & 0xF);
    printf ("Step       : %ld\n", (get_cpu_function (0x80000001, &ax, &bx, &cx, &dx)) & 0xF);

    get_cpu_function (0x80000006, &ax, &bx, &cx, &dx);
    printf ("L2Cache    : %ld Kb\n", (cx >> 16) & 0xFFFF);

    printf ("Brand      : %s", get_cpu_brand (0x80000002));
    printf ("%s", get_cpu_brand (0x80000003));
    printf ("%s\n", get_cpu_brand (0x80000004));

    if ((get_cpu_function (0x80000000, &ax, &bx, &cx, &dx) & 0xFF) >= 8) {
        printf ("Hammer     : 0x%.8lx\n\n", (get_cpu_function (0x80000008, &ax, &bx, &cx, &dx)));
    }

    for (i = 0x0; i < 0x2; i++) {
        get_cpu_function (i, &ax, &bx, &cx, &dx);
        printf ("EAX:%.8lx: %.8lx EBX:%.8lx: %.8lx ECX:%.8lx: %.8lx EDX:%.8lx: %.8lx\n", i, ax, i, bx, i, cx, i, dx);
    }

    printf ("\n");

    for (i = 0x80000000; i <= 0x80000008; i++) {
        get_cpu_function (i, &ax, &bx, &cx, &dx);
        printf ("EAX:%.8lx: %.8lx EBX:%.8lx: %.8lx ECX:%.8lx: %.8lx EDX:%.8lx: %.8lx\n", i, ax, i, bx, i, cx, i, dx);
    }

    return 0;
}
