/*
 *  $Id: list.c 107 2008-04-17 01:01:43Z mbroeker $
 * $URL: http://localhost/svn/c/lsflib/trunk/src/list.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <list.h>

Node *addnode (Node * node, char *data)
{
    Node *n;

    if ((n = malloc (sizeof (Node))) == NULL) {
        fprintf (stderr, "malloc fails: %s\n", data);
        return NULL;
    }

    if (!(n->data = strdup (data))) {
        fprintf (stderr, "strdup fails: %s\n", data);
        free (n);
        return NULL;
    }

    n->next = NULL;

    if (node != NULL) {
        node->next = n;
        node = n;
    } else
        node = n;

    return node;
}

Node *getnode (Node * aktuell)
{
    Node *begin;

    free (aktuell->data);
    begin = aktuell->next;
    free (aktuell);

    return begin;
}
