/**
 * $Id: main.c,v 1.1.1.1 2008-04-28 17:32:52 mbroeker Exp $
 * $Source: /development/c/asm/main.c,v $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#ifndef TIMEOUT
#define TIMEOUT 500
#endif

int get_sp ();

void sigendian ()
{
    unsigned short word = 0x1234;
    unsigned char *p = (unsigned char *)&word;

    signal (SIGUSR1, sigendian);
    printf ("%s Endian System\n", (p[0] == 0x34) ? "Little" : "Big");
}

void sigproc ()
{
    signal (SIGINT, sigproc);
    printf ("Stack-Pointer is at %08x\n", get_sp ());
}

void sigquit ()
{
    printf ("Hmm... You got it, man!\n");
    exit (0);
}

int main (int argc, char **argv)
{
    signal (SIGINT, sigproc);
    signal (SIGUSR1, sigendian);
    signal (SIGQUIT, sigquit);

    for (;;)
        usleep (TIMEOUT);

    return EXIT_FAILURE;
}
