/**
 * test/demos/pmc/main.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <cube.h>
#include <SDL/SDL.h>

unsigned long color;
SDL_Surface *screen;

#ifndef STEP
#define STEP 1
#endif

int main (int argc, char **argv)
{

    unsigned long red, black;
    SDL_Event event;

    if (argc != 2) {
        std::cout << "USAGE: " << argv[0]
            << " height" << std::endl;
        exit (0);
    }
    int h = atoi (argv[1]);

    if ((h < 10) || (h >= 360))
        h = 200;

    Vector p1 (0, 0, 0);
    Vector p2 (0, h, 0);
    Vector p3 (h, 0, 0);
    Vector p4 (h, h, 0);

    SDL_Init (SDL_INIT_VIDEO);
    screen = SDL_SetVideoMode (1010, 700, 16, SDL_HWSURFACE);
    red = SDL_MapRGB (screen->format, 0xff, 0x00, 0x00);
    black = SDL_MapRGB (screen->format, 0x00, 0x00, 0x00);

    Cube *c = new Cube (p1, p2, p3, p4, h);
    Cube *d = new Cube (p1, p2, p3, p4, h);

    c->move (Vector (100, 250, 0));
    d->move (Vector (400, 250, 0));

    bool running = true;
    int x, y, z;

    x = y = z = 0;

    while (running) {
        SDL_PollEvent (&event);

        if (event.type == SDL_QUIT)
            running = false;

        if (event.type == SDL_KEYDOWN) {
            color = black;
            c->show ();
            d->show ();
            color = red;

            switch (event.key.keysym.sym) {
            case SDLK_ESCAPE:
                running = false;
                break;

            case SDLK_UP:
                c->move ((Vector (x, y - STEP, z)));
                d->move ((Vector (x, y - STEP, z)));
                break;

            case SDLK_DOWN:
                c->move ((Vector (x, y + STEP, z)));
                d->move ((Vector (x, y + STEP, z)));
                break;

            case SDLK_LEFT:
                c->move ((Vector (x - STEP, y, z)));
                d->move ((Vector (x - STEP, y, z)));
                break;

            case SDLK_RIGHT:
                c->move ((Vector (x + STEP, y, z)));
                d->move ((Vector (x + STEP, y, z)));
                break;
            default:
                break;
            }

            c->show ();
            d->show ();
            SDL_Flip (screen);
        }
    }

    delete c;
    delete d;

    SDL_Quit ();

    return 0;
}
