/**
 * test/demos/pmc/rectangle.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <rectangle.h>
#include <cstdio>

Rectangle::Rectangle (Surface * s)
{
    P[0] = new Vector (0, 0);
    P[1] = new Vector (0, 100);
    P[2] = new Vector (100, 100);
    P[3] = new Vector (0, 100);

    anker = Vector (0, 0);

    surface = s;
}

Rectangle::Rectangle (Surface * s, Vector& p1, Vector& p2, Vector& p3, Vector& p4)
{
    P[0] = new Vector (p1);
    P[1] = new Vector (p2);
    P[2] = new Vector (p3);
    P[3] = new Vector (p4);

    anker = Vector (0, 0);

    surface = s;
}

Rectangle::~Rectangle ()
{
    for (int i = 0; i < 4; i++) {
#ifdef DEBUG
        fprintf (stderr, "Removing P[%d]: ", i);
#endif
        delete P[i];
    }
}

void Rectangle::move (Vector location)
{
    if ((anker.X () + location.X ()) < 0)
        return;
    if ((anker.Y () + location.Y ()) < 0)
        return;

    if ((anker.X () + location.X ()) >= surface->getWidth ())
        return;
    if ((anker.Y () + location.Y ()) >= surface->getHeight ())
        return;

    for (int i = 0; i < 4; i++) {
        *P[i] = *P[i] + location;
    }

    anker = Vector (P[0]->X (), P[0]->Y ());
}

void Rectangle::show ()
{
    int i;

    for (i = 0; i < 4; i++) {
        fprintf (stderr, "[%d] ", i);
        P[i]->vector ();
        if ((i + 1) % 4 != 0)
            fprintf (stderr, ", ");
        else
            fprintf (stderr, "\n");
    }

    surface->drawLine (P[0]->X (), P[0]->Y (), P[1]->X (), P[1]->Y ());
    surface->drawLine (P[3]->X (), P[3]->Y (), P[2]->X (), P[2]->Y ());

    surface->drawLine (P[2]->X (), P[2]->Y (), P[1]->X (), P[1]->Y ());
    surface->drawLine (P[3]->X (), P[3]->Y (), P[0]->X (), P[0]->Y ());
}
