/**
 * test/demos/pmc/cube.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <cube.h>
#include <cstdio>

Cube::Cube (Surface * s)
{
    P[0] = new Vector (0, 0);
    P[1] = new Vector (100, 0);
    P[2] = new Vector (100, 100);
    P[3] = new Vector (0, 100);

    P[4] = new Vector (25, 25);
    P[5] = new Vector (125, 25);
    P[6] = new Vector (125, 125);
    P[7] = new Vector (25, 125);

    surface = s;
    height = 25;
}

Cube::Cube (Surface * s, Vector& p1, Vector& p2, Vector& p3, Vector& p4, int h)
{
    height = h;
    surface = s;
    Vector location(h/2, h/2);

    P[0] = new Vector (p1);
    P[1] = new Vector (p2);
    P[2] = new Vector (p3);
    P[3] = new Vector (p4);

    for (int i = 0; i < 4; i++) {
        P[4 + i] = new Vector (*P[i]);
        *P[4 + i] = *P[i] + location;
    }
}

Cube::~Cube ()
{
    for (int i = 0; i < 8; i++) {
#ifdef DEBUG
        fprintf (stderr, "Removing P[%d]: ", i);
#endif
        delete P[i];
    }
}

void Cube::move (Vector location)
{
    for (int i = 0; i < 8; i++) {
        *P[i] = *P[i] + location;
    }
}

void Cube::show ()
{
	/* Implement some Sanity Checks */
    int height = surface->getHeight ();

    surface->drawLine (P[0]->X (), P[0]->Y (), P[1]->X (), P[1]->Y ());
    surface->drawLine (P[3]->X (), P[3]->Y (), P[2]->X (), P[2]->Y ());
    surface->drawLine (P[2]->X (), P[2]->Y (), P[1]->X (), P[1]->Y ());
    surface->drawLine (P[3]->X (), P[3]->Y (), P[0]->X (), P[0]->Y ());

    surface->drawLine (P[4]->X (), P[4]->Y (), P[5]->X (), P[5]->Y ());
    surface->drawLine (P[7]->X (), P[7]->Y (), P[6]->X (), P[6]->Y ());
    surface->drawLine (P[7]->X (), P[7]->Y (), P[4]->X (), P[4]->Y ());
    surface->drawLine (P[6]->X (), P[6]->Y (), P[5]->X (), P[5]->Y ());

    surface->drawLine (P[0]->X (), P[0]->Y (), P[4]->X (), P[4]->Y ());
    surface->drawLine (P[1]->X (), P[1]->Y (), P[5]->X (), P[5]->Y ());

    surface->drawLine (P[2]->X (), P[2]->Y (), P[6]->X (), P[6]->Y ());
    surface->drawLine (P[3]->X (), P[3]->Y (), P[7]->X (), P[7]->Y ());
}
