/**
 * lsflib/tools/dump.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>

#include <bits.h>

int main (int argc, char **argv)
{
    int fd;;
    int len;
    int i;
    char buffer[81];
    char key = 0xf3;

    int use_BINARY, use_NOT, use_HEX, use_XOR;

    use_XOR = use_HEX = use_BINARY = use_NOT = *buffer = 0;

    while ((i = getopt (argc, argv, "bhnk:x?")) >= 0) {
        switch (i) {
        case 'b':
            use_BINARY = 1;
            break;
        case 'h':
            use_HEX = 1;
            break;
        case 'k':
            key = atoi (optarg);
            break;
        case 'n':
            use_NOT = 1;
            break;
        case 'x':
            use_XOR = 1;
            break;
        case '?':
            printf ("Usage: %s [ -b|-h|-n|-x|-? ] [ file ]\n", argv[0]);
            printf ("b: binary\nh: hex\nn: not\nx: xor\n");
            printf ("If no filename is given, stdin is assumed\n");
            return 0;
        }
    }

    if (optind == argc)
        fd = fileno (stdin);
    else {
        if ((fd = open (argv[optind], O_RDONLY)) == -1) {
            perror ("OPEN");
            return EXIT_SUCCESS;
        }
    }
    while ((len = read (fd, buffer, 1)) > 0) {
        buffer[len] = 0;

        if (use_BINARY && use_XOR && use_NOT) {
            bindump (not (xor (buffer, key)), BITS);
        } else if (use_BINARY && use_XOR) {
            bindump (xor (buffer, key), BITS);
        } else if (use_BINARY && use_NOT) {
            bindump (not (buffer), BITS);
        } else if (use_BINARY) {
            bindump (buffer, BITS);

        } else if (use_HEX && use_XOR && use_NOT) {
            hexdump (not (xor (buffer, key)), len);
        } else if (use_HEX && use_XOR) {
            hexdump (xor (buffer, key), len);
        } else if (use_HEX && use_NOT) {
            hexdump (not (buffer), len);
        } else if (use_HEX) {
            hexdump (buffer, len);
        } else if (use_XOR && use_NOT) {
            printf ("%s", not (xor (buffer, key)));
        } else if (use_XOR) {
            printf ("%s", xor (buffer, key));
        } else if (use_NOT) {
            printf ("%s", not (buffer));
        } else
            printf ("%s", buffer);
    }

    close (fd);

    return 0;
}
