package org.homelinux.largo.app;

import java.util.List;
import java.sql.SQLException;
import org.homelinux.largo.sql.client.DBClient;

public class App {
	public static void main (String args[]) {
		DBClient db = null;
		int i = 0;

		try {
			db = new DBClient ();
			List<String> list = db.getTables ();

			System.out.println ("TABLES IN THE CURRENT DATABASE");
			for (String s : list) {
				System.out.printf ("[%04d] %s%n", i++, s);
			}
			System.out.println ();

			list = db.getColumns("EUROLEAGUE");
			System.out.println ("COLUMN NAMES IN THIS TABLE");
			for (String s : list) {
				System.out.printf ("%s ", s);
			}
			System.out.printf ("%n%n");

			i = db.update ("delete from euroleague where bonus>0");
			System.out.printf ("Deleted: %3d lines%n", i);
			db.query ("select * from euroleague order by team");

			while (db.hasNext ()) {
				System.out.println (db.getColumn ("team"));
			}
		} catch (SQLException sqle) {
			System.out.println ("SQLException: " + sqle.getMessage());
		} catch (Exception e) {
			e.printStackTrace ();
		} finally {
			try {
				if (db != null) {
					System.out.println ("Disconnecting from database...");
					db.disconnect();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
