/*
 *  $Id: md5recursive.c 94 2008-04-05 01:27:30Z mbroeker $
 * $URL: http://localhost/svn/c/lsflib/trunk/src/md5recursive.c $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <lsf.h>

void md5recursive (char *root, int recursive)
{
    struct dirent *entry;
    DIR *directory;
    char *list;
    unsigned char *value;
    int i;

    if (!isDir (root))
        return;

    if ((directory = opendir (root)) == NULL) {
        perror (root);
        return;
    }

    while ((entry = readdir (directory))) {
        list = (char *)malloc (strlen (root) + 1 + strlen (entry->d_name) + 1);

        if (list == NULL) {
            perror ("malloc");
            return;
        }

        sprintf (list, "%s/%s", root, entry->d_name);

        if (!strcmp (entry->d_name, "."))
            continue;

        if (!strcmp (entry->d_name, ".."))
            continue;

        if (isDir (list)) {
            fprintf (stderr, "Directory: %s\n", list);
            if (recursive) {
                md5recursive (list, recursive);
            }
            continue;
        }

        if ((value = md5sum (list)) == NULL) {
            continue;
        }

        for (i = 0; i < 16; i++)
            printf ("%02x", value[i]);
        printf ("  %s\n", list);
        free (value);
    }

    free (list);
    closedir (directory);
}
