#include <console.h>

int Console::getch ()
{
    static int ch = -1, fd = 0;
    struct termios neu, alt;

    fd = fileno (stdin);
    tcgetattr (fd, &alt);
    neu = alt;
    neu.c_lflag &= ~(ICANON | ECHO);
    tcsetattr (fd, TCSANOW, &neu);
    ch = getchar ();
    tcsetattr (fd, TCSANOW, &alt);
    return ch;
}

void Console::getpass (std::string & password)
{
    int i = 0;
    int c;
    char buffer[17];

    while ((c = getch ()) != '\n' && i < 17) {
        buffer[i++] = c;
        std::cout << "*";
    }
    buffer[i] = 0;

    password = std::string (buffer);
    std::cout << std::endl;
}
