/**
 * libConsole/cross_getch.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <jni.h>
#include <Console.h>

#ifdef WIN32
#include <conio.h>

int cross_getch ()
{
    int ch = -1;

    ch = getch ();

    return ch;
}

#else
#include <termios.h>

int cross_getch ()
{
    int ch = -1, fd = 0;
    struct termios neu, alt;

    fd = fileno (stdin);
    tcgetattr (fd, &alt);
    neu = alt;
    neu.c_lflag &= ~(ICANON | ECHO);
    tcsetattr (fd, TCSANOW, &neu);
    ch = getchar ();
    tcsetattr (fd, TCSANOW, &alt);
    return ch;
}
#endif

JNIEXPORT jint JNICALL Java_Console_getch (JNIEnv * env, jclass lass)
{
    return cross_getch ();
}
