/**
 * db_bridge/main.cpp
 * Copyright (C) 2008 Markus Broeker
 */

#ifdef WITH_POSTGRESQL
#include <postgresql_db.h>
#else
#include <mysql_db.h>
#endif

int main (int argc, char **argv)
{
    Abstract_DB *db;

    Abstract_DB::DB_ROW vec;
    Abstract_DB::DB_RESULT result;
    unsigned int i, j;

#ifdef WITH_POSTGRESQL
    db = new PostgreSQL_DB ("", "largo", "", "clubstatistik");
#else
    db = new MySQL_DB ("localhost", "dbuser", "dbpasswd", "datenbank");
#endif

    if (db->connect () == false) {
        std::cerr << "Kann mich nicht zur Datenbank verbinden. Passwoerter falsch?" << std::endl;
        return EXIT_FAILURE;
    }

    result = db->query ("select * from euroleague");

    for (i = 0; i < result.size (); i++) {
        vec = result[i];
        for (j = 0; j < vec.size (); j++) {
            std::cout << vec[j] << " ";
        }
        std::cout << std::endl;
    }

    delete db;

    return EXIT_SUCCESS;
}
