/**
 * db_bridge/include/abstract_db.h
 * Copyright 2008 (C) Markus Broeker
 */

#ifndef ABSTRACT_DB_H
#define ABSTRACT_DB_H

#include <vector>
#include <string>

class Abstract_DB {
  protected:
    std::string user;
    std::string database;
    std::string password;
    std::string server;

  public:
    typedef std::vector < std::vector<std::string> > DB_RESULT;
    typedef std::vector<std::string> DB_ROW;

    virtual ~ Abstract_DB () {}
    virtual bool connect () = 0;
    virtual DB_RESULT query (std::string) = 0;
};
#endif
