/**
 * lsflib/src/get_line.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <string.h>

#include <lsf/lsf.h>

#ifndef LINE_LENGTH
#define LINE_LENGTH 100
#endif

char *get_line (const char *filename, const char *cmd, size_t size)
{
    int i, j;
    char *line, *ptr;

    FILE *f = fopen (filename, "r");

    if (!f) {
        perror ("FOPEN:");
        return NULL;
    }

    line = malloc (LINE_LENGTH + 1);
    ptr = malloc ((LINE_LENGTH + 1) * size);
    i = 0;

    while (fgets (line, LINE_LENGTH, f) != NULL) {
        if (strstr (line, cmd)) {
            do {
                if ((strlen (ptr) + strlen (line)) < LINE_LENGTH * size) {
                    strcat (ptr, line);
                    fgets (line, LINE_LENGTH, f);
                    i++;
                } else {
                    printf ("OVERFLOW: [%d]: %s\n", i * LINE_LENGTH, line);
                    exit (0);
                }
            } while (strchr (line, '"') == NULL);
            if (i > 1)
                strcat (ptr, line);
        }
        for (i = 0; i < strlen (ptr); i++)
            switch (ptr[i]) {
            case '\n':
            case '\\':
            case '"':
                for (j = i; j < strlen (ptr) - 1; j++)
                    ptr[j] = ptr[j + 1];
                ptr[j] = 0;
                break;
            }
    }

    fclose (f);
    free (line);

    return ptr;
}
