/**
 * test/demos/pmc/vector.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <cmath>
#include <vector.h>

#include <cstdio>

using namespace algebra;

Vector::Vector (int xx, int yy)
{
    name = "Vector";
    x = xx;
    y = yy;
    mode = RAD;

#ifdef DEBUG
    fprintf (stderr, "New Vector: (%.3d, %.3d)\n", x, y);
#endif
}

Vector::~Vector ()
{
#ifdef DEBUG
    fprintf (stderr, "Bye, bye Vector: (%.3d, %.3d)\n", x, y);
#endif
}

int Vector::X ()
{
    return x;
}

int Vector::Y ()
{
    return y;
}

Vector Vector::operator+ (Vector & a)
{
    return Vector (x + a.X (), y + a.Y ());
}

Vector Vector::operator- (Vector & a)
{
    return Vector (x - a.X (), y - a.Y ());
}

double Vector::abs ()
{
    return (std::sqrt (x * x + y * y));
}

void Vector::vector ()
{
    fprintf (stderr, "(%.3d, %.3d)", x, y);
}

double Vector::angle (Vector & v)
{
    if (mode == DEG)
        return ((180.0 / M_PI) * std::acos ((v.X () * X () + v.Y () * Y ()) / (abs () * v.abs ())));

    return (std::acos ((v.X () * X () + v.Y () * Y ()) / (abs () * v.abs ())));
}

void Vector::setMode (Mode m)
{
    mode = m;
}
