/**
 * lsflib/src/getdir.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <lsf/lsf.h>

int isDir (char *filename)
{
    struct stat buf;

    if (!lstat (filename, &buf))
        return (S_ISDIR (buf.st_mode));

    return 0;
}

int isFile (char *filename)
{
    struct stat buf;

    if (!lstat (filename, &buf))
        return (S_ISREG (buf.st_mode));

    return 0;
}

int isLink (char *filename)
{
    struct stat buf;

    if (!lstat (filename, &buf))
        return (S_ISLNK (buf.st_mode));

    return 0;
}

void getdir (char *root, int recursive)
{
    struct dirent *entry;
    DIR *directory;
    char *list;

    if (!isDir (root))
        return;

    if ((directory = opendir (root)) == NULL) {
        perror (root);
        return;
    }

    while ((entry = readdir (directory))) {
        if ((!strcmp (entry->d_name, ".")) || (!strcmp (entry->d_name, "..")))
            continue;

        list = malloc (strlen (root) + 1 + strlen (entry->d_name) + 1);
        sprintf (list, "%s/%s", root, entry->d_name);

        if (isDir (list)) {
            printf ("Directory: %s\n", list);
            if (recursive)
                getdir (list, recursive);
            free (list);
            continue;
        }

        printf ("%s\n", list);
        free (list);
    }

    closedir (directory);
}
