/**
 * test/demos/pmc/include/surface.h
 * Copyright (C) 2008 Markus Broeker
 */

#ifndef SURFACE_H
#define SURFACE_H

#include <object.h>
#include <SDL/SDL.h>

class Surface:public Object {
  private:
    int width;
    int height;
    int depth;

    Uint32 color, red, black;
    SDL_Surface *screen;

  public:
    enum foregroundColor { BLACK, RED };
      Surface (int w, int h, int d);
     ~Surface ();

    int getWidth () {
        return width;
    };

    int getHeight () {
        return height;
    };

    void drawPixel (int x, int y);
    void drawLine (int x1, int y1, int x2, int y2);

    void flip ();
    void setColor (enum foregroundColor);
};
#endif
