/**
 * test/demos/pmc/main.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <surface.h>
#include <rectangle.h>
#include <cube.h>

#include <cstdio>
#include <cstdlib>

#ifndef STEP
#define STEP 1
#endif

#define MAX 3

using namespace algebra;

int main (int argc, char **argv)
{
    Surface *surface;
    SDL_Event event;
    Drawable *d[MAX];

    int height;

    if (argc != 2) {
        fprintf (stderr, "Usage: %s <HEIGHT>\n", argv[0]);
        height = 250;
    } else
        height = atoi (argv[1]);

    if ((height < 10) || (height >= 360))
        height = 200;

    Vector p1 (0, 0);
    Vector p2 (height, 0);
    Vector p3 (height, height);
    Vector p4 (0, height);

    surface = new Surface (1024, 768, 16);

    d[0] = new Rectangle (surface, p1, p2, p3, p4);
    d[1] = new Cube (surface);
    d[2] = new Cube (surface, p1, p2, p3, p4, height);

    bool running = true;
    int i, x, y;

    x = y = 0;

    d[1]->move (Vector (25, 25));
    d[2]->move (Vector (290, 0));

    while (running) {
        SDL_PollEvent (&event);

        if (event.type == SDL_QUIT)
            running = false;

        if (event.type == SDL_KEYDOWN) {
            surface->setColor (Surface::BLACK);
            for (i = 0; i < MAX; i++)
                d[i]->show ();
            surface->setColor (Surface::RED);

            switch (event.key.keysym.sym) {
            case SDLK_ESCAPE:
                running = false;
                break;

            case SDLK_UP:
                for (i = 0; i < MAX; i++)
                    d[i]->move ((Vector (x, y - STEP)));
                break;

            case SDLK_DOWN:
                for (i = 0; i < MAX; i++)
                    d[i]->move ((Vector (x, y + STEP)));
                break;

            case SDLK_LEFT:
                for (i = 0; i < MAX; i++)
                    d[i]->move ((Vector (x - STEP, y)));
                break;

            case SDLK_RIGHT:
                for (i = 0; i < MAX; i++)
                    d[i]->move ((Vector (x + STEP, y)));
                break;
            default:
                break;
            }

            for (i = 0; i < MAX; i++) {
                d[i]->show ();
            }

            surface->flip ();
        }
    }

    for (i = 0; i < MAX; i++)
        delete d[i];

    delete surface;

    return EXIT_SUCCESS;
}
