#include <console.h>
#include <cstdio>

#ifdef WIN32
#include <conio.h>
int Console::getch ()
{
    return::getch ();
}
#else
#include <termios.h>
int Console::getch ()
{
    static int ch = -1, fd = 0;
    struct termios neu, alt;

    fd = fileno (stdin);
    tcgetattr (fd, &alt);
    neu = alt;
    neu.c_lflag &= ~(ICANON | ECHO);
    tcsetattr (fd, TCSANOW, &neu);
    ch = getchar ();
    tcsetattr (fd, TCSANOW, &alt);
    return ch;
}
#endif

void Console::getpass (std::string & password)
{
    int i = 0;
    int c;
    char buffer[17];

    while ((c = Console::getch ()) != '\n' && i < 17) {
        buffer[i++] = c;
        std::cout << "\b*";
    }
    buffer[i] = 0;

    password = std::string (buffer);
    std::cout << std::endl;
}
