/**
 * test/demos/pmc/cube.cc
 * Copyright (C) 2008 Markus Broeker
 */

#include <cube.h>
#include "../sdl.cc"

extern SDL_Surface *screen;
extern unsigned long color;

Cube::Cube (Vector p1, Vector p2, Vector p3, Vector p4, int h)
{
    P[0] = new Vector (p1);
    P[1] = new Vector (p2);
    P[2] = new Vector (p3);
    P[3] = new Vector (p4);

    P[4] = new Vector (p1.X (), p1.Y (), p1.Z () + h);
    P[5] = new Vector (p2.X (), p2.Y (), p2.Z () + h);
    P[6] = new Vector (p3.X (), p3.Y (), p3.Z () + h);
    P[7] = new Vector (p4.X (), p4.Y (), p4.Z () + h);

    height = h;
}

Cube::~Cube ()
{
    for (int i = 0; i < 8; i++)
        delete P[i];
}

void Cube::move (Vector location)
{
    for (int i = 0; i < 8; i++) {
        *P[i] = *P[i] + location;
    }
}

void Cube::show ()
{
    P[0]->vector ();
    std::cout << ", ";
    P[1]->vector ();
    std::cout << std::endl;
    P[2]->vector ();
    std::cout << ", ";
    P[3]->vector ();
    std::cout << std::endl;

    P[4]->vector ();
    std::cout << ", ";
    P[5]->vector ();
    std::cout << std::endl;
    P[6]->vector ();
    std::cout << ", ";
    P[7]->vector ();
    std::cout << std::endl;

    drawLine (screen, P[0]->X (), P[0]->Y (), P[1]->X (), P[1]->Y (), color);
    drawLine (screen, P[2]->X (), P[2]->Y (), P[3]->X (), P[3]->Y (), color);
    drawLine (screen, P[0]->X (), P[0]->Y (), P[2]->X (), P[2]->Y (), color);
    drawLine (screen, P[1]->X (), P[1]->Y (), P[3]->X (), P[3]->Y (), color);

    drawLine (screen, (int)(height / 2.0) + P[4]->X (),
              (int)(height / 2.0) + P[4]->Y (),
              (int)(height / 2.0) + P[5]->X (), (int)(height / 2.0) + P[5]->Y (), color);

    drawLine (screen, (int)(height / 2.0) + P[6]->X (),
              (int)(height / 2.0) + P[6]->Y (),
              (int)(height / 2.0) + P[7]->X (), (int)(height / 2.0) + P[7]->Y (), color);

    drawLine (screen, (int)(height / 2.0) + P[4]->X (),
              (int)(height / 2.0) + P[4]->Y (),
              (int)(height / 2.0) + P[6]->X (), (int)(height / 2.0) + P[6]->Y (), color);

    drawLine (screen, (int)(height / 2.0) + P[5]->X (),
              (int)(height / 2.0) + P[5]->Y (),
              (int)(height / 2.0) + P[7]->X (), (int)(height / 2.0) + P[7]->Y (), color);

    drawLine (screen, P[0]->X (), P[0]->Y (),
              (int)(height / 2.0) + P[4]->X (), (int)(height / 2.0) + P[4]->Y (), color);

    drawLine (screen, P[2]->X (), P[2]->Y (),
              (int)(height / 2.0) + P[6]->X (), (int)(height / 2.0) + P[6]->Y (), color);

    drawLine (screen, P[1]->X (), P[1]->Y (),
              (int)(height / 2.0) + P[5]->X (), (int)(height / 2.0) + P[5]->Y (), color);

    drawLine (screen, P[3]->X (), P[3]->Y (),
              (int)(height / 2.0) + P[7]->X (), (int)(height / 2.0) + P[7]->Y (), color);
}
