/**
 * test/demos/db_bridge/console.cpp
 * Copyright (C) Markus Broeker
 */

#include <console.hpp>
#include <cstdio>

#ifdef WIN32
#include <conio.h>

int Console::getch ()
{
    int ch = -1;

    ch =::getch ();

    return ch;
}
#else
#include <termios.h>

int Console::getch ()
{
    int ch = -1, fd = 0;
    struct termios neu, alt;

    fd = fileno (stdin);
    tcgetattr (fd, &alt);
    neu = alt;
    neu.c_lflag &= ~(ICANON | ECHO);
    tcsetattr (fd, TCSANOW, &neu);
    ch = getchar ();
    tcsetattr (fd, TCSANOW, &alt);
    return ch;
}
#endif

void Console::getpass (std::string & password)
{
    int i = 0;
    int c;
    char buffer[17];

    while (((c = Console::getch ()) != '\n') && i < 17) {
        if (c != BS) {
            buffer[i++] = c;
            std::cout << "*";
        } else if (i > 0) {
            i--;
            std::cout << "\b \b";
        }
    }
    buffer[i] = 0;
    std::cout << std::endl;

    password = std::string (buffer);
}
