/**
 * test/demos/pmc/include/vector.h
 * Copyright (C) 2008 Markus Broeker
 */

#ifndef VECTOR_H
#define VECTOR_H

#include <object.h>

namespace algebra {
    class Vector:public Object {
      public:
        enum Mode { DEG, RAD, GRAD };

        Vector (int xx = 0, int yy = 0);
        virtual ~ Vector ();

        int X ();
        int Y ();

        Vector operator+ (Vector &);
        Vector operator- (Vector &);
        double abs ();

        void vector ();
        double angle (Vector &);
        void setMode (Mode m = RAD);

      private:
        Mode mode;
        int x;
        int y;
    };
}
#endif
