/**
 * test/demos/parser/lexer.ll
 * Copyright (C) 2008 Markus Broeker
 */

%{
	#include <stdio.h>
	#include "parser.h"
%}

%%

[0-9]+		{ yylval = atoi(yytext); return DIGIT; }
[a-zA-Z]	{ yylval = yytext[0]; return LETTER; }
"+"		{ return PLUS; }
"-"		{ return MINUS; }
"*"		{ return MUL; }
"/"		{ return DIV; }
"("|")"|"="	{ return yytext[0]; }
[ \t]+		{}
\n		{ return yytext[0]; }
.		{ printf("FEHLER: %s\n", yytext); }
%%
