/**
 * unix.c
 * Copyright (C) 2010 Markus Broeker
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <assert.h>
#include <jni.h>

int isUnixLink (const char *name)
{
    struct stat st;

    assert (lstat (name, &st) == 0);
    return (S_ISLNK (st.st_mode));
}

JNIEXPORT jint JNICALL Java_Unix_isUnixLink (JNIEnv * env, jclass jc, jstring s)
{
    const char *c_string = (*env)->GetStringUTFChars (env, s, NULL);
    return isUnixLink (c_string);
}
