package org.homelinux.largo.sql.client;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DBClient {
	private Connection connection;
	private Statement statement;
	private ResultSet resultset;

	private String driver, username, password;
	private String dbURL;

	/**
	 * Default Konstruktor to connect to my database
	 */
	public DBClient () throws Exception {
		this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
		this.dbURL = "jdbc:derby://localhost/clubstatistik";

		this.username = null;
		this.password = null;

		Class.forName (driver);
		connection = DriverManager.getConnection (dbURL, username, password);
		statement = connection.createStatement ();
	}

	/**
	 * Default Konstruktor to connect to my DataPool
	 */
	public DBClient (String jndiResource) throws Exception {
		Context ctx = new InitialContext ();
		DataSource ds = (DataSource) ctx.lookup (jndiResource);

		connection = ds.getConnection ();
		statement = connection.createStatement ();
	}

	/**
	 * Default Konstruktor to connect to my database with auth-data
	 */
	public DBClient (String driver, String dbURL, String username, String password) throws Exception {
		this.driver = driver;
		this.dbURL = dbURL;

		this.username = username;
		this.password = password;

		Class.forName (driver);
		connection = DriverManager.getConnection (dbURL, username, password);
		statement = connection.createStatement ();
	}

	public void close () throws Exception {
		connection.close ();
	}

	public String getColumn (int pos) throws Exception {
		return resultset.getString (pos);
	}

	public String getColumn (String name) throws Exception {
		return resultset.getString (name);
	}

	public Connection getConnection () {
		return connection;
	}

	public String getDbURL () {
		return dbURL;
	}

	public String getDriver () {
		return driver;
	}

	public String getPassword () {
		return password;
	}

	public String getUsername () {
		return username;
	}

	public boolean hasNext () throws Exception {
		return resultset.next ();
	}

	public void query (String query) throws Exception {
		resultset = statement.executeQuery (query);
	}

	public void setConnection (Connection connection) {
		this.connection = connection;
	}

	public void setDbURL (String dbURL) {
		this.dbURL = dbURL;
	}

	public void setDriver (String driver) {
		this.driver = driver;
	}

	public void setPassword (String password) {
		this.password = password;
	}

	public void setUsername (String username) {
		this.username = username;
	}
}
