/**
 * db_bridge/main.cpp
 * Copyright (C) 2008 Markus Broeker
 */

#ifdef WITH_POSTGRESQL
#include <postgresql_db.h>
#else
#include <mysql_db.h>
#endif

#include <cstdlib>

void usage (std::string progname)
{
    std::cout << "Benutzung: " << progname << " [-h] [-r <remotehost>] [-u <user>] [-p <password>] DATABASE\n";
	std::cout << "\t\t-r <remotehost>\t\tVerbindung zu Fremdrechner <remotehost>\n";
	std::cout << "\t\t-u <user>\t\tAnmeldung als <user>\n";
	std::cout << "\t\t-p <password>\t\tAnmelden mit dem Passwort <password>\n";
	std::cout << "\n";
	std::cout << "\t\tDATABASE\t\tVerbindung zur Datenbank DATABASE herstellen\n";
    std::cout << "\nBerichten Sie Fehler oder Anregungen an mbroeker@largo.homelinux.org" << std::endl;
    exit (0);
}

int main (int argc, char **argv)
{
    Abstract_DB *db;

    Abstract_DB::DB_ROW vec;
    Abstract_DB::DB_RESULT result;
    unsigned int i, j;
    char c;

    std::string host, user, pass, database;
    std::string sql_statement;

    while ((c = getopt (argc, argv, "r:u:p:h")) >= 0) {
        switch (c) {
        case 'r':
            host = optarg;
            break;
        case 'u':
            user = optarg;
            break;
        case 'p':
            pass = optarg;
            break;
        case 'h':
            usage (argv[0]);
            break;
        }
    }
    if (optind < argc)
        database = argv[optind];
    else
        usage (argv[0]);

#ifdef WITH_POSTGRESQL
    db = new PostgreSQL_DB (host, user, pass, database);
#else
    db = new MySQL_DB (host, user, pass, database);
#endif

    if (db->connect () == false) {
        std::cerr << "Kann mich nicht zur Datenbank verbinden. Passwoerter falsch?" << std::endl;
        return EXIT_FAILURE;
    }

    for (;;) {
        std::cout << "DB_BRIDGE # ";
        std::getline (std::cin, sql_statement);

        if (sql_statement == "quit" || sql_statement == "exit" || sql_statement == "") {
            std::cout << std::endl;
            break;
        }
        result = db->query (sql_statement);

        for (i = 0; i < result.size (); i++) {
            vec = result[i];
            for (j = 0; j < vec.size (); j++) {
                std::cout << vec[j] << " ";
            }
            std::cout << std::endl;
        }
    }

    delete db;

    return EXIT_SUCCESS;
}
