/**
 * Q3ListView Demo
 */

#include <QApplication>
#include "view.hpp"

void TView::down ()
{
    Q3ListViewItem *item = listView->selectedItem ();
    Q3ListViewItem *cur, *next;

    if ((cur = item) == NULL)
        return;
    if ((next = cur->itemBelow ()) == NULL)
        return;

    /*
     * move cur after next
     */
    cur->moveItem (next);

    /*
     * highlight the next item
     */
    listView->setSelected (cur, true);
}

void TView::up ()
{
    Q3ListViewItem *item = listView->selectedItem ();
    Q3ListViewItem *cur, *next;

    if ((cur = item) == NULL)
        return;
    if ((next = cur->itemAbove ()) == NULL)
        return;

    /*
     * move next after cur
     */
    next->moveItem (cur);

    /*
     * highlight the next item
     */
    listView->setSelected (cur, true);
}

TView::TView (QWidget * parent)
:  QDialog (parent, 0)
{
    Q3ListViewItem *item = NULL;

    setupUi (this);

    listView->addColumn ("Picture");
    listView->addColumn ("Artist");
    listView->addColumn ("Price");

    item = new Q3ListViewItem (listView, item, "Mona Lisa", "Leonardo da Vinci", "35.000.000");
    item = new Q3ListViewItem (listView, item, "The Thinker", "Auguste Rodin", "12.850.000");
    item = new Q3ListViewItem (listView, item, "Starnight", "Vincent van Gogh", "435.000");
    item = new Q3ListViewItem (listView, item, "The Kiss", "Gustav Klimt", "125.000");

    connect (upButton, SIGNAL (clicked ()), this, SLOT (up ()));
    connect (downButton, SIGNAL (clicked ()), this, SLOT (down ()));

    item = listView->firstChild ();
    listView->setSelected (item, true);
    listView->setSorting (-1, FALSE);
}

TView::~TView ()
{
    listView->clear ();
}

int main (int argc, char **argv)
{
    QApplication app (argc, argv);
    TView view;

    app.setMainWidget (&view);
    view.show ();
    return app.exec ();
}
