/***
 *
 * $Id: sdl.cc,v 1.1.1.1 2008-04-28 17:33:22 mbroeker Exp $
 * $Source: /development/cpp/pmc/sdl.cc,v $
 *
 */

#include <SDL/SDL.h>

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define abs(a) (((a)<0) ? -(a) : (a))
#define sign(a) (((a)<0) ? -1 : (a)>0 ? 1 : 0)

void drawLine (SDL_Surface * s, int x1, int y1, int x2, int y2, Uint32 color)
{
    int d;
    int x;
    int y;
    int ax;
    int ay;
    int sx;
    int sy;
    int dx;
    int dy;

    Uint8 *lineAddr;
    Sint32 yOffset;

    dx = x2 - x1;
    ax = abs (dx) << 1;
    sx = sign (dx);

    dy = y2 - y1;
    ay = abs (dy) << 1;
    sy = sign (dy);
    yOffset = sy * s->pitch;

    x = x1;
    y = y1;

    lineAddr = ((Uint8 *) s->pixels) + (y * s->pitch);
    if (ax > ay) {              /* x dominant */
        d = ay - (ax >> 1);
        for (;;) {
            *((Uint16 *) (lineAddr + (x << 1))) = (Uint16) color;

            if (x == x2) {
                return;
            }
            if (d >= 0) {
                y += sy;
                lineAddr += yOffset;
                d -= ax;
            }
            x += sx;
            d += ay;
        }
    } else {                    /* y dominant */
        d = ax - (ay >> 1);
        for (;;) {
            *((Uint16 *) (lineAddr + (x << 1))) = (Uint16) color;

            if (y == y2) {
                return;
            }
            if (d >= 0) {
                x += sx;
                d -= ay;
            }
            y += sy;
            lineAddr += yOffset;
            d += ax;
        }
    }
}
