/***
 *
 * $Id: pmc.h,v 1.1.1.1 2008-04-28 17:33:22 mbroeker Exp $
 * $Source: /development/cpp/pmc/include/pmc.h,v $
 */

#ifndef PMC_H
#define PMC_H

#include <iostream>
#include <object.h>

namespace pmc {
    class Vector:public Object {
      private:
        int x;
        int y;
        int z;

      public:
        enum Mode { DEG, RAD, GRAD };

          Vector (int xx = 0, int yy = 0, int zz = 0);
          virtual ~ Vector ();

        int X ();
        int Y ();
        int Z ();

        Vector operator+ (Vector);
        Vector operator- (Vector);
        int operator* (Vector);
        double abs ();

        void vector ();
        double angle (Vector);
        void setMode (Mode m = RAD);

      private:
          Mode mode;
    };
}
#endif
